﻿//---------------------------------------------------------------------------------------------------------
// start actions:

//-----------------------------------------------------------------

  package{
	  import flash.display.*;
	  import flash.events.*;
	  import flash.text.*;
	  
	  public class MainMenu extends MovieClip{
		 
		 public var arrItems:Array = new Array();
		 var dispatcher:EventDispatcher = new EventDispatcher();
		 var strJustSelected:String = "";
		 
		 //inline elements:
		 // mc_item_gallery
		 // mc_item_export
		 
		 //constructor
		 public function MainMenu(){
			registerItem(mc_item_gallery);
			registerItem(mc_item_export);
			
			setItemSelected(mc_item_gallery);
		 }
		 		 
				
		 //----------------------------------------------------------------
		 // unselect all items
	     public function unselectAllItems(){
			 for each (var mc_item in this.arrItems) setItemNormal(mc_item);
		 }
		 		
		 //----------------------------------------------------------------
		 // set selected item
		 public function setItemSelected(mc_item){
			 unselectAllItems();
			 mc_item.buttonMode = false;
			 mc_item.gotoAndStop(3);
		 }
		 
		 //----------------------------------------------------------------
		 // set the item over state
		 public function setItemOver(mc_item){
			 mc_item.gotoAndStop(2);
		 }
		 
		 //----------------------------------------------------------------
		 // set normal state 
		 public function setItemNormal(mc_item){
			 mc_item.buttonMode = true;
			 mc_item.gotoAndStop(1);
		 }
		 
		 //----------------------------------------------------------------
		 // register item, and set event.
		 public function registerItem(mc_item){
			 this.gotoAndStop(1);
			 mc_item.buttonMode = true;
			 mc_item.mouseChildren = false;
			 
			 //set events:			 
			 mc_item.addEventListener(MouseEvent.MOUSE_DOWN,onMenuItemClick);
			 mc_item.addEventListener(MouseEvent.MOUSE_OVER,onMenuItemOver);
			 mc_item.addEventListener(MouseEvent.MOUSE_OUT,onMenuItemOut);
			 
			 //add item to array of items
			 this.arrItems.push(mc_item);			 
		 }
		 
		 //----------------------------------------------------------------
		 // tell is the item selected
		 public function isItemSelected(mc_item){
			if(mc_item.currentFrame == 3) return(true);
			return(false);
		 }
		 
		 //----------------------------------------------------------------
		 // on mouse over event. set over state
		 public function onMenuItemOver(event:MouseEvent){
			 var mc_item = event.target;
			 if(isItemSelected(mc_item) == true) return(false);
			 setItemOver(mc_item);
		 }
		 
		 //----------------------------------------------------------------
		 // on mouse out event. set item normal state
		 public function onMenuItemOut(event:MouseEvent){
			 var mc_item = event.target;
			 if(isItemSelected(mc_item) == true) return(false);
			 setItemNormal(mc_item);			 
		 }
		 
		 //----------------------------------------------------------------
		 // event on menu item click. do some operation
		 public function onMenuItemClick(event:MouseEvent){
			 var mc_item = event.target;
			 if(isItemSelected(mc_item) == true) return(false);
			 
			 var menuItemName = mc_item.name;
			 
			 switch(menuItemName){
				 default:						//default behaviour - get selected
				 	setItemSelected(mc_item);
				 break;
			 }
			 
			 doMenuAction(menuItemName);
		 }
		 
		 //----------------------------------------------------------------
		 // set just selected name
		 public function setJustSelectedName(strName:String){
			 this.strJustSelected = strName;
		 }
		 
		 //----------------------------------------------------------------
		 // get just selected name
		 public function getJustSelectedName(){
			 return(this.strJustSelected);
		 }
		 		 
		 //----------------------------------------------------------------
		 // do menu action according the menu item
		 function doMenuAction(itemName:String){
			 
			 switch(itemName){
				 case "mc_item_gallery":
					setJustSelectedName("gallery");
				 break;
				 case "mc_item_export":
					 setJustSelectedName("export");
				 break;
				 default:
				 	trace("doMenuAction error - wrong menu item name: " + itemName);
				 break;
			 }
			 
			 this.dispatcher.dispatchEvent(new Event("menuSelected"));
		 }
		 
	  }
  }